# Provenance

This document tracks the origin and version of all data files, code modules, scripts, analysis routines, and tests used in this pipeline. Replace each `<commit-hash>` with the actual Git commit SHA.

---

## Data Files

- **data/D_values.csv**  
  Fractal‑dimension anchors from Volume 3.  
  Commit: `<commit-hash>`

- **data/pivot_params.json**  
  Pivot parameters `a` and `b` from Volume 4.  
  Commit: `<commit-hash>`

- **data/fractal_fit.pkl**  
  Fitted logistic parameters `[Dmin, Dmax, k, n0]` for D(n).  
  Commit: `<commit-hash>`

- **data/kernel.npy**  
  Reproduction‑kernel matrix constructed in Volume 4.  
  Commit: `<commit-hash>`

- **data/discrete_action.pkl**  
  Symbolic discrete master action S_disc.  
  Commit: `<commit-hash>`

- **results/samples.h5**  
  Path‑integral field configuration samples.  
  Commit: `<commit-hash>`

- **results/composite.h5**  
  Composite 4D moment–operator samples.  
  Commit: `<commit-hash>`

- **results/rg_flow.npy**  
  Renormalization‑group flow values vs. scale.  
  Commit: `<commit-hash>`

- **results/anomalies.npy**  
  Anomaly indicator values for each sample.  
  Commit: `<commit-hash>`

---

## Code Modules

- **ar_sim/common/fractal_fits.py**  
  Fractal‑dimension fitting & interpolation routines (Volumes 2–3 & 6).  
  Commit: `<commit-hash>`

- **ar_sim/common/kernel_builder.py**  
  Reproduction‑kernel construction & eigen routines with D≈2 identity fix (Volumes 3–4 & 6).  
  Commit: `<commit-hash>`

- **ar_sim/common/composite_moment.py**  
  Composite moment operator (2D & 4D collapse + retarded tick) from Vol 6.  
  Commit: `<commit-hash>`

- **ar_sim/continuum_action.py**  
  Discrete→continuum action derivation (Legendre transform) from Volume 4.  
  Commit: `<commit-hash>`

- **ar_sim/path_integral.py**  
  Path‑integral Metropolis–Hastings sampler (Volume 4).  
  Commit: `<commit-hash>`

---

## Scripts

- **scripts/calibrate_pivot.py**  
  Calibrate pivot function parameters g(D)=aD+b (Volume 4).  
  Commit: `<commit-hash>`

- **scripts/build_kernel.py**  
  Build reproduction‑kernel matrix from anchors (Volume 4).  
  Commit: `<commit-hash>`

- **scripts/compute_action.py**  
  Compute symbolic discrete master action (Volume 4).  
  Commit: `<commit-hash>`

- **scripts/run_path_integral.py**  
  CLI driver for end‑to‑end simulation (Volume 4).  
  Commit: `<commit-hash>`

- **scripts/apply_composite_moment.py**  
  Apply 4D composite moment operator to samples (Volume 6).  
  Commit: `<commit-hash>`

- **scripts/run_rg_flow.py**  
  Compute renormalization‑group flow (Volume 6).  
  Commit: `<commit-hash>`

- **scripts/compute_anomalies.py**  
  Compute anomaly indicators for each sample (Volume 6).  
  Commit: `<commit-hash>`

---

## Analysis Modules

- **analysis/observables.py**  
  Correlator, β‑function, and anomaly calculation routines (Volumes 4 & 6).  
  Commit: `<commit-hash>`

- **analysis/rg_flow_analysis.py**  
  Load and compare RG‑flow to target β‑function curves (Volume 6).  
  Commit: `<commit-hash>`

---

## Tests

- **tests/test_fractal_fits.py**  
  Validates fractal‑fit reproduces known D(n) parameters (Volumes 2–3).  
  Commit: `<commit-hash>`

- **tests/test_kernel_spectra.py**  
  Verifies reproduction‑kernel eigenvalues against Volume 3 benchmarks.  
  Commit: `<commit-hash>`

- **tests/test_pivot_params.py**  
  Asserts pivot_params.json yields known (a,b)=(-1.35,3.70) calibration (Volume 4).  
  Commit: `<commit-hash>`

---

*Once you’ve added these entries, commit the file and replace each `<commit-hash>` with the corresponding SHA to complete the provenance.*

